#include <bits/stdc++.h>
using namespace std;

#define int long long
#define X first
#define Y second
#define all(x) (x).begin(), (x).end()

int prod(const pair<int, int> &a, const pair<int, int> &b) {
    return a.X * b.Y - b.X * a.Y;
}

int sgn(int x) {
    if (x < 0) {
        return -1;
    } else if (x > 0) {
        return 1;
    } else {
        return 0;
    }
}

int check(const pair<int, int> &as, const pair<int, int> &ae, const pair<int, int> &bs, const pair<int, int> &be) {
    return sgn(prod({be.X - as.X, be.Y - as.Y}, {ae.X - as.X, ae.Y - as.Y})) * sgn(prod({bs.X - as.X, bs.Y - as.Y}, {ae.X - as.X, ae.Y - as.Y}));
}

int intersect(const pair<int, int> &as, const pair<int, int> &ae, const pair<int, int> &bs, const pair<int, int> &be) {
    return max({check(as, ae, bs, be), check(ae, as, bs, be), check(bs, be, as, ae), check(be, bs, as, ae)});
}

struct DSU {
    vector<int> p;
    DSU(int n) {
        p.assign(n, 0);
        iota(all(p), 0);
    }
    int get(int x) {
        return (x == p[x] ? x : (p[x] = get(p[x])));
    }
    void merge(int a, int b) {
        a = get(a);
        b = get(b);
        if (a != b) {
            p[a] = b;
        }
    }
};

void solve() {
    int n;
    cin >> n;
    vector<pair<pair<int, int>, pair<int, int>>> seg(n);
    for (int i = 0; i < n; i++) {
        cin >> seg[i].X.X >> seg[i].X.Y >> seg[i].Y.X >> seg[i].Y.Y;
    }
    DSU dsu(n);
    int v = 2 * n, e = n;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < i; j++) {
            if (seg[i].X == seg[j].X || seg[i].X == seg[j].Y || seg[i].Y == seg[j].X || seg[i].Y == seg[j].Y) {
                dsu.merge(i, j);
                v--;
                continue;
            }
            int k = intersect(seg[i].X, seg[i].Y, seg[j].X, seg[j].Y);
            if (k == 0 && (max(seg[i].X.X, seg[i].Y.X) < min(seg[j].X.X, seg[j].Y.X) || min(seg[i].X.X, seg[i].Y.X) > max(seg[j].X.X, seg[j].Y.X) || max(seg[i].X.Y, seg[i].Y.Y) < min(seg[j].X.Y, seg[j].Y.Y) || min(seg[i].X.Y, seg[i].Y.Y) > max(seg[j].X.Y, seg[j].Y.Y))) {
                k = 1;
            }
            if (k != 1) {
                dsu.merge(i, j);
            }
            if (k == 0) {
                e++;
            } else if (k == -1) {
                v++;
                e += 2;
            }
        }
    }
    set<int> s;
    for (int i = 0; i < n; i++) {
        s.insert(dsu.get(i));
    }
    cout << e - v + (int)s.size() + 1 << '\n';
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int t = 1;
    cin >> t;
    while (t--) solve();
}